import javax.swing.*;

public class ClockGame {

   private Player player; // The player --null if no game
   private Clock clock;   // The clock --null if no game

   // The window --null if no game-- that maintains the clock and the
   // game status.
   private ClockWindow clockWindow;
   
   /** Constructor: a clock game. Prompts for the player name and
      initial level, and displays a window that contains a clock and
      the game status. */
   public ClockGame() {
      // Read in name of player and initial level
      String name= 
         JOptionPane.showInputDialog("Hi! What's your name?");
      if (name == null) return;
      int level=
         readInt("What level would you like to start at?", 1, 4, 1);
      if (level == -1) return;
            
      player= new Player(name, level);                
      clock= new Clock(new Time(12,0));
      clockWindow= new ClockWindow(clock, player.toString());
   }
   
   /** Play the game until the player stops it */
   public void playGame() {
      if (player == null) return;
      
      while (makeAGuess()) 
         {}
      clockWindow.dispose();
      player= null;                   
   } 
   
   /* Make one play of game. This involves setting the clock to a 
      random time for the given level, asking the player what time they
      think it is, and processing their answer. 
      Return false if player wants to cancel the game, true otherwise */
   private boolean makeAGuess() {

      clock.setTime(getRandomTime());

      // Read in a guess from player
      int hours= readInt("Please enter hours: ", 1, 12, 1);
      if (hours < 0)
         { return false; }

      int minutes= 0;
      if (player.getLevel() != 1)
         { minutes= readInt("Please enter the minutes: ", 0, 59, 0); }
      if (minutes < 0)
         { return false; }

      Time guess= new Time(hours, minutes);
      
      // Check the guess and act accordingly
      String s; // the player response
      if (guess.equals(clock.getTime())) {
         player.incrementScore();
         clockWindow.setStatus(player.toString());
         s= JOptionPane.showInputDialog("You got it right! " +
               clock.getTime().toString() +
               "\nClick OK when you are ready for the next play." +
               "\nClick Cancel to stop playing.");
      } else {
         s= JOptionPane.showInputDialog("Sorry, the correct time is " +
               clock.getTime().toString() + ", not " + 
               (new Time(hours, minutes)).toString() +
               "\nClick OK when you are ready for the next play" +
               "\nClick Cancel to stop playing.");
      }

      if (s == null)
         { return false; }

      return true;
   }
   
   /** Return a random time, but based on the level of the player.
      If the level is 1 (or 2, 3, 4), the minutes should be 0
      (or a multiple of 15, a multiple of 5, a multiple of 1) */
   private Time getRandomTime() {

      int level= player.getLevel();
      double dminutes= Math.random();
      int minutes;

      if (level == 1) {
         minutes= 0;
      } else if (level == 2) {
         minutes= 15 * (int) Math.round(dminutes*3);
      } else if (level == 3) {
         minutes= 5 * (int)Math.round(dminutes*11);
      } else {
         minutes= (int)Math.round(dminutes*59);
      }
      
      int hours= 1 + (int) Math.round(Math.random()*11);
      return new Time(hours, minutes);
   }
   
   /** Read in an integer in the range h..k using a JOptionPane
      with prompt s. The message s + "\nType an integer in the range
      h..k" will appear in the dialog box. Return the integer --but if
      something not in range h..k is typed, return default def.
      If the player hit the Cancel button, return the value -1. */
   private static int readInt(String s, int h, int k, int def) {
      int number; // The number to be returned
      String input= JOptionPane.showInputDialog(s + 
            "\nType a number in the range " + h + ".." + k + "." +
            "\nHit Cancel to quit the game");

      try {
         if (input == null)
            { return -1; }
         number= Integer.parseInt(input.trim());
      } catch (NumberFormatException e) {
         number= def;
      } catch (NullPointerException e) {
         number= def;
      }

      if (number < h  ||  k < number)
         { number= def; }
      return number;
   }
}
